<?php
/*Skrypt pochodzi z ksiki "PHP. 101 praktycznych skryptw"
  autor: Marcin Lis                    http://marcinlis.com*/
function resize_image($src_dir, $dest_dir, $imgName, $scale)
{
  if(!($img = imagecreatefromjpeg($src_dir.$imgName))){
    echo("Nie mog otworzy pliku: $imgName");
    return false;
  }

  $img_w = imagesx($img);
  $img_h = imagesy($img);
  $new_img_w = $img_w * $scale / 100;
  $new_img_h = $img_h * $scale / 100;

  $tempImg = imagecreatetruecolor($new_img_w, $new_img_h);
  imagecopyresized($tempImg, $img, 0, 0, 0, 0, 
                   $new_img_w, $new_img_h, $img_w, $img_h);

  $name = substr($imgName, 0, strlen($imgName) - 4);
  $name = $name."-resized.jpg";

  imagejpeg($tempImg, $dest_dir.$name);
}

function resize_dir_images($src_dir, $dest_dir = "", $size)
{
  if(!($fd = opendir($src_dir))) return false;
  $array = array();
  $count = 0;
  while (($file = readdir($fd)) !== false){
    if($file != "." && $file != ".."){
      $array[$count++] = $file;
    }
  }
  if($dest_dir == "") $dest_dir = $src_dir;
  foreach($array as $key => $file){
    resize_image($src_dir, $dest_dir, $file, $size);
  }
  closedir($fd);
}
resize_dir_images("./images/", "", 50);
?>
